/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.mail.storage;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.mail.MailMessage;
import net.impactdev.impactor.api.mail.filters.MailFilter;
import net.impactdev.impactor.api.storage.Storage;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.impactdev.impactor.core.mail.storage.MailStorageImplementation;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.utility.future.ThrowingRunnable;
import net.impactdev.impactor.core.utility.future.ThrowingSupplier;
import net.kyori.adventure.util.TriState;

public final class MailStorage
implements Storage {
    private final MailStorageImplementation implementation;

    MailStorage(MailStorageImplementation implementation) {
        this.implementation = implementation;
    }

    @Override
    public void init() throws Exception {
        this.implementation.init();
    }

    @Override
    public void shutdown() throws Exception {
        this.implementation.shutdown();
    }

    @Override
    public CompletableFuture<Void> meta(PrettyPrinter printer) {
        return MailStorage.run(() -> this.implementation.meta(printer));
    }

    public CompletableFuture<List<MailMessage>> mail(UUID target) {
        return MailStorage.supply(() -> this.implementation.mail(target)).orTimeout(5L, TimeUnit.SECONDS);
    }

    public CompletableFuture<Boolean> send(UUID target, MailMessage message) {
        return MailStorage.supply(() -> this.implementation.append(target, message));
    }

    public CompletableFuture<TriState> delete(UUID target, MailMessage message) {
        return MailStorage.supply(() -> this.implementation.delete(target, message));
    }

    public CompletableFuture<TriState> deleteWhere(UUID target, MailFilter filter) {
        return MailStorage.supply(() -> this.implementation.deleteWhere(target, filter));
    }

    private static CompletableFuture<Void> run(ThrowingRunnable runnable2) {
        return CompletableFuture.runAsync(() -> {
            try {
                runnable2.run();
            }
            catch (Exception e) {
                ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new CompletionException(e);
            }
        }, Impactor.instance().scheduler().async());
    }

    private static <T> CompletableFuture<T> supply(ThrowingSupplier<T> supplier) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return supplier.supply();
            }
            catch (Exception e) {
                ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new CompletionException(e);
            }
        }, Impactor.instance().scheduler().async());
    }
}

